import BannerSection from "../components/BannerSection";
import FilterSidebar from "../components/FilterSidebar";
import FindJobBanner from "../components/FindJobBanner";
import JobCard from "../components/JobCard";

export default async function ListingPage() {
  
  const res = await fetch("https://dev.nesogent.com/api/job-posts", {
    cache: "no-store",
  });

  if (!res.ok) {
    // basic error UI
    return (
      <>
        <BannerSection />
        <section className="py-10">
          <div className="max-w-[1400px] mx-auto px-4">
            <p className="text-red-500 text-sm">
              Failed to load job posts. Please try again later.
            </p>
          </div>
        </section>
        <FindJobBanner />
      </>
    );
  }

  const json = await res.json();

  const posts: any[] = json?.data ?? [];
  const meta = json?.meta ?? null;

  const from = meta?.from ?? (posts.length ? 1 : 0);
  const to = meta?.to ?? posts.length;
  const total = meta?.total ?? posts.length;

  return (
    <>
      {/* Banner Section */}
      <BannerSection />

      {/* Job Listing Section */}
      <section className="py-10">
        <div className="max-w-[1400px] mx-auto px-4 flex flex-col lg:flex-row gap-6">
          {/* Sidebar */}
          <FilterSidebar />

          {/* Job listing area */}
          <div className="w-full lg:w-[70%]">
            {/* header row */}
            <div className="flex items-center justify-between mb-6">
              <p className="text-sm text-gray-600">
                Showing {from} - {to} of {total} Results
              </p>
              <div className="flex items-center gap-3">
                <select className="border rounded px-3 py-2 text-sm">
                  <option>Sort by (Default)</option>
                </select>
                <select className="border rounded px-3 py-2 text-sm">
                  <option>10 Per</option>
                </select>
              </div>
            </div>

            {/* cards grid */}
            <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
              {posts.map((post: any) => {
                const companyName =
                  post.recruiter?.company_name ?? post.recruiter?.name ?? "Company";

                const location =
                  post.locality && post.city
                    ? `${post.locality}, ${post.city}`
                    : post.city || post.locality || "Location not specified";

                const salary = `₹${post.pay_amount?.toLocaleString?.("en-IN") ?? post.pay_amount ?? 0}`;

                const shift =
                  post.shift_timing === "day"
                    ? "Day Shift"
                    : post.shift_timing === "night"
                    ? "Night Shift"
                    : post.shift_timing || "Shift";

                // You can decide what "type" should show: category name or work_type
                const type =
                  post.category?.name ??
                  (post.work_type === "wfo" ? "Work From Office" : post.work_type) ??
                  "Job Type";

                return (
                  <JobCard
                    key={post.id}
                    title={post.title}
                    company={companyName}
                    location={location}
                    salary={salary}
                    payType={post.pay_type} 
                    type={type}
                    shift={shift}
                    startDate={post.start_date}
                    logo="/images/icon1.png"
                  />
                );
              })}
            </div>

            {/* pagination visual only for now (API has meta.links if you later want real pagination) */}
            <div className="mt-8 flex justify-center">
              <nav className="inline-flex items-center gap-2 text-sm text-gray-600">
                <button className="px-2">«</button>
                {meta?.links?.map((link: any, idx: number) => {
                  // show only numeric page links
                  const isNumber = !isNaN(Number(link.label));
                  if (!isNumber) return null;

                  return (
                    <button
                      key={idx}
                      className={`w-8 h-8 rounded ${
                        link.active ? "bg-emerald-700 text-white" : "bg-white"
                      } border`}
                    >
                      {link.label}
                    </button>
                  );
                })}
                <button className="px-2">»</button>
              </nav>
            </div>
          </div>
        </div>
      </section>

      <FindJobBanner />
    </>
  );
}
