"use client"

import { useState } from 'react';
import Link from 'next/link';
import { HiOutlineUser, HiMenu, HiX } from "react-icons/hi"; 

import BtnStyleOne from "./BtnStyleOne";
import BtnStyleTwo from "./BtnStyleTwo";

export default function Navbar() {
  const [open, setOpen] = useState(false)

  const logoUrl = "/images/logo.svg";

  return (
    <header className="bg-white text-[#1B2021]">
      <div className="max-w-[1400px] mx-auto px-4">
        <div className="flex items-center justify-between h-20">
          <div className="flex items-center gap-4">
            <Link href="/" className="flex items-center gap-3">
              <img
                src={logoUrl}
                alt="Company Logo"
                className="h-10 object-cover rounded-sm"
              />
            </Link>
          </div>

          <nav className="hidden md:flex items-center space-x-6">
            <Link href="/" className="hover:text-[#0B8260] transition-colors">Home</Link>

            <div className="group relative">
              <button className="inline-flex items-center gap-1 hover:text-[#0B8260]">
                <span>Nav Option</span>
                <svg className="w-3 h-3 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" d="M19 9l-7 7-7-7" />
                </svg>
              </button>
              <div className="absolute left-0 mt-2 w-44 bg-white border rounded shadow-md opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all">
                <Link href="#" className="block px-4 py-2 text-sm hover:bg-gray-50">Option 1</Link>
                <Link href="#" className="block px-4 py-2 text-sm hover:bg-gray-50">Option 2</Link>
              </div>
            </div>

            <Link href="/listing" className="hover:text-[#0B8260]">Job Listing</Link>
            <Link href="#" className="hover:text-[#0B8260]">Nav Option</Link>
          </nav>

          <div className="hidden md:flex items-center gap-4">
            <BtnStyleTwo href="/auth/signin" label="SignIn" icon={HiMenu} iconClassName="w-4 h-4" />
            <BtnStyleOne href="/auth/register" label="Register Today" />
          </div>

          <div className="md:hidden flex items-center">
            <button
              onClick={() => setOpen(!open)}
              aria-label="Toggle menu"
              className="p-2 rounded-md inline-flex items-center justify-center text-[#1B2021] hover:bg-gray-100"
            >
              {open ? <HiX className="w-6 h-6" /> : <HiMenu className="w-6 h-6" />}
            </button>
          </div>
        </div>
      </div>

      <div
        className={`md:hidden bg-white border-t transition-max-h duration-300 overflow-hidden ${open ? 'max-h-[600px]' : 'max-h-0'}`}
      >
        <div className="px-4 pt-4 pb-6 space-y-3">
          <Link href="/" className="block text-base font-medium">Home</Link>

          <details className="border rounded">
            <summary className="px-3 py-2 cursor-pointer">Nav Option</summary>
            <div className="px-3 py-2 space-y-1">
              <Link href="#" className="block text-sm">Option 1</Link>
              <Link href="#" className="block text-sm">Option 2</Link>
            </div>
          </details>

          <Link href="#" className="hover:text-[#0B8260]">Nav Option</Link>
          <Link href="#" className="hover:text-[#0B8260]">Nav Option</Link>

          <div className="pt-2 border-t mt-2 flex items-center justify-between">
            <Link href="/pages/signin" className="flex items-center gap-2 text-sm">
              <HiOutlineUser className="w-5 h-5" /> 
              <span>Sign In</span>
            </Link>
            <BtnStyleOne href="/pages/signin" label="Sign In" />
            <BtnStyleOne href="/pages/register" label="Register Today" />
          </div>
        </div>
      </div>
    </header>
  )
}
