// components/JobCard.tsx
import Link from "next/link";
import { FaStar } from "react-icons/fa";

type JobCardProps = {
  title: string;
  company: string;
  location: string;
  salary: string;
  type: string;
  shift: string;
  startDate: string;
  logo: string;
};

export default function JobCard({
  title,
  company,
  location,
  salary,
  type,
  shift,
  startDate,
  logo,
}: JobCardProps) {
  return (
    <article className="bg-white border border-gray-200 rounded-lg p-5 shadow-sm">
      <div className="flex gap-4">
        <div className="w-14 h-14 rounded-md bg-emerald-50 flex items-center justify-center text-2xl font-bold text-emerald-700">
          <img
            src={logo}
            alt="Company Logo"
            className="h-10 object-cover rounded-sm"
          />
        </div>

        <div className="flex-1">
          <h3 className="text-lg font-medium text-[#333333]">{title}</h3>
          <p className="text-sm text-[#6E8497] font-normal mt-1">{company}</p>

          <div className="flex items-center gap-1 mt-2 text-yellow-400">
            <FaStar size={16} />
            <FaStar size={16} />
            <FaStar size={16} />
            <FaStar size={16} />
            <FaStar size={16} className="text-[#C7D2DD]" />
          </div>
        </div>
      </div>

      <div className="gap-4">
        <p className="text-sm font-normal text-[#30363F] mt-3">
          Consistently create well-designed, tested work using best
          practices for field jobs and safety protocols...
        </p>

        <div className="flex flex-wrap gap-2 mt-3">
          <span className="text-xs bg-[#F8F8F8] px-2 py-1 rounded text-[#6E8497] font-medium">
            {shift}
          </span>
          <span className="text-xs bg-[#F8F8F8] px-2 py-1 rounded text-[#6E8497] font-medium">
            {type}
          </span>
          <span className="text-xs bg-[#F8F8F8] px-2 py-1 rounded text-[#6E8497] font-medium">
            {location}
          </span>
        </div>

        <div className="mt-4 flex items-center justify-between text-sm">
          <div className="flex items-center gap-4">
            <span className="font-semibold text-[#1B2021]">
              {salary}/
              <span className="font-semibold text-[#6E8497]">Daily</span>
            </span>
            <span className="text-gray-300">|</span>
            <span className="text-[#30363F]">Start date: {startDate}</span>
          </div>

          <div className="flex items-center gap-3">
            <Link
              href="#"
              className="bg-emerald-700 text-white rounded font-normal text-[14px] px-5 py-3"
            >
              Quick Apply
            </Link>
          </div>
        </div>
      </div>
    </article>
  );
}
