"use client";

import { useState } from "react";
import Link from "next/link";
import { FaCaretDown } from "react-icons/fa";
import DoubleRangeSlider from "../components/DoubleRangeSlider";
import NewsletterCard from "../components/NewsletterCard";

export default function SearchFilter() {
  const [open, setOpen] = useState<string | null>("Payment Type");

  const toggle = (name: string) => {
    setOpen((prev) => (prev === name ? null : name));
  };

  return (
    <div className="w-full lg:w-[30%]">
      <div className="mb-5 bg-white border border-gray-200 rounded-lg p-5 shadow-sm">
        {/* Header */}
        <div className="flex items-center justify-between mb-4">
          <h2 className="text-lg font-semibold text-[#1B2021]">Search Filter</h2>
          <Link
            href="#"
            className="text-[15px] opacity-60 no-underline text-sm text-[#0F161E] hover:no-underline"
          >
            Clear
          </Link>
        </div>

        <div className="mt-4 space-y-4 text-sm text-gray-600">
          <div className="w-full max-w-sm space-y-3">
            {/* Payment Type */}
            <div className="border-b border-b-[#F1F1F1]">
              <button
                type="button"
                onClick={() => toggle("Payment Type")}
                className="flex w-full items-center justify-between py-2"
              >
                <h3 className="font-medium text-sm text-[#2D3954]">
                  Payment Type
                </h3>
                <span
                  className={`bg-emerald-50 flex h-[30px] w-[30px] items-center justify-center rounded-full text-emerald-700 transition-transform duration-200 ${
                    open === "Payment Type" ? "rotate-180" : ""
                  }`}
                >
                  <FaCaretDown size={14} />
                </span>
              </button>

              {open === "Payment Type" && (
                <div className="pb-3 pt-1">
                  <div className="space-y-2 text-xs text-gray-700">
                    <label className="flex items-center gap-2">
                      <input type="checkbox" /> Hourly (12)
                    </label>
                    <label className="flex items-center gap-2">
                      <input type="+" /> Fixed Price (8)
                    </label>
                    <label className="flex items-center gap-2">
                      <input type="checkbox" /> Commission (5)
                    </label>
                  </div>
                </div>
              )}
            </div>

            {/* Job Locations */}
            <div className="border-b border-b-[#F1F1F1]">
              <button
                type="button"
                onClick={() => toggle("Job Locations")}
                className="flex w-full items-center justify-between py-2"
              >
                <h3 className="font-medium text-sm text-[#0F161E]">
                  Job Locations
                </h3>
                <span
                  className={`bg-emerald-50 flex h-[30px] w-[30px] items-center justify-center rounded-full text-emerald-700 transition-transform duration-200 ${
                    open === "Job Locations" ? "rotate-180" : ""
                  }`}
                >
                  <FaCaretDown size={14} />
                </span>
              </button>

              {open === "Job Locations" && (
                <div className="pb-3 pt-1">
                  <div className="space-y-2 text-xs text-gray-700">
                    <label className="flex items-center gap-2">
                      <input type="checkbox" /> Dhaka (24)
                    </label>
                    <label className="flex items-center gap-2">
                      <input type="checkbox" /> Chittagong (11)
                    </label>
                    <label className="flex items-center gap-2">
                      <input type="checkbox" /> Remote (7)
                    </label>
                  </div>
                </div>
              )}
            </div>

            {/* Job Categories */}
            <div className="border-b border-b-[#F1F1F1]">
              <button
                type="button"
                onClick={() => toggle("Job Categories")}
                className="flex w-full items-center justify-between py-2"
              >
                <h3 className="font-medium text-sm text-[#0F161E]">
                  Job Categories
                </h3>
                <span
                  className={`bg-emerald-50 flex h-[30px] w-[30px] items-center justify-center rounded-full text-emerald-700 transition-transform duration-200 ${
                    open === "Job Categories" ? "rotate-180" : ""
                  }`}
                >
                  <FaCaretDown size={14} />
                </span>
              </button>

              {open === "Job Categories" && (
                <div className="pb-3 pt-1">
                  <div className="space-y-2 text-xs text-gray-700">
                    <label className="flex items-center gap-2">
                      <input type="checkbox" /> Electrician (62)
                    </label>
                    <label className="flex items-center gap-2">
                      <input type="checkbox" /> Plumber (31)
                    </label>
                    <label className="flex items-center gap-2">
                      <input type="checkbox" /> Carpenter (20)
                    </label>
                  </div>
                </div>
              )}
            </div>

            {/* Shift timing */}
            <div className="border-b border-b-[#F1F1F1]">
              <button
                type="button"
                onClick={() => toggle("Shift timing")}
                className="flex w-full items-center justify-between py-2"
              >
                <h3 className="font-medium text-sm text-[#0F161E]">
                  Shift timing
                </h3>
                <span
                  className={`bg-emerald-50 flex h-[30px] w-[30px] items-center justify-center rounded-full text-emerald-700 transition-transform duration-200 ${
                    open === "Shift timing" ? "rotate-180" : ""
                  }`}
                >
                  <FaCaretDown size={14} />
                </span>
              </button>

              {open === "Shift timing" && (
                <div className="pb-3 pt-1">
                  <div className="space-y-2 text-xs text-gray-700">
                    <label className="flex items-center gap-2">
                      <input type="checkbox" /> Morning
                    </label>
                    <label className="flex items-center gap-2">
                      <input type="checkbox" /> Evening
                    </label>
                    <label className="flex items-center gap-2">
                      <input type="checkbox" /> Night
                    </label>
                  </div>
                </div>
              )}
            </div>

            <DoubleRangeSlider
                initialMin={25}
                initialMax={75}
                onChange={(min, max) => {
                  // এখানে min/max ধরে API call / filter apply করবে
                }}
              />
              
              


            {/* Job Type */}
            <div className="border-b border-b-[#F1F1F1]">
              <button
                type="button"
                onClick={() => toggle("Job Type")}
                className="flex w-full items-center justify-between py-2"
              >
                <h3 className="font-medium text-sm text-[#0F161E]">
                  Job Type
                </h3>
                <span
                  className={`bg-emerald-50 flex h-[30px] w-[30px] items-center justify-center rounded-full text-emerald-700 transition-transform duration-200 ${
                    open === "Job Type" ? "rotate-180" : ""
                  }`}
                >
                  <FaCaretDown size={14} />
                </span>
              </button>

              {open === "Job Type" && (
                <div className="pb-3 pt-1">
                  <div className="space-y-2 text-xs text-gray-700">
                    <label className="flex items-center gap-2">
                      <input type="checkbox" /> Full-Time
                    </label>
                    <label className="flex items-center gap-2">
                      <input type="checkbox" /> Part-Time
                    </label>
                  </div>
                </div>
              )}
            </div>

            {/* Button */}
            <button className="w-full mt-4 bg-emerald-700 text-white py-2 rounded-md text-sm">
              Search Jobs
            </button>
          </div>
        </div>
      </div>
          <NewsletterCard />
    </div>


  );
}
