"use client";

import { useState, useMemo } from "react";

export default function DoubleRangeSlider() {
  const min = 0;
  const max = 100;

  const [minValue, setMinValue] = useState(25);
  const [maxValue, setMaxValue] = useState(75);

  // percentage হিসাব (style এর জন্য)
  const minPercent = useMemo(
    () => ((minValue - min) / (max - min)) * 100,
    [minValue]
  );
  const maxPercent = useMemo(
    () => ((maxValue - min) / (max - min)) * 100,
    [maxValue]
  );

  // later development এ এই দুইটা state থেকেই value পাবে:
  // minValue, maxValue

  const handleMinChange = (e: React.ChangeEvent<HTMLInputElement>) => {
    const value = Math.min(Number(e.target.value), maxValue - 1);
    setMinValue(value);
  };

  const handleMaxChange = (e: React.ChangeEvent<HTMLInputElement>) => {
    const value = Math.max(Number(e.target.value), minValue + 1);
    setMaxValue(value);
  };

  return (
    <div className="w-full mt-4">
  {/* upper bubbles */}
  <div className="relative h-8 mb-3">
    <div
      className="absolute -top-1 flex h-7 w-7 items-center justify-center rounded-full bg-emerald-700 text-[11px] text-white -translate-x-1/2"
      style={{ left: `${minPercent}%` }}
    >
      {minValue}
    </div>
    <div
      className="absolute -top-1 flex h-7 w-7 items-center justify-center rounded-full bg-emerald-700 text-[11px] text-white -translate-x-1/2"
      style={{ left: `${maxPercent}%` }}
    >
      {maxValue}
    </div>
  </div>

  {/* track + active range + knobs */}
  <div className="relative h-6">
    <div className="absolute top-1/2 h-2 w-full -translate-y-1/2 rounded-full bg-gray-300" />
    <div
      className="absolute top-1/2 h-2 -translate-y-1/2 rounded-full bg-emerald-700"
      style={{
        left: `${minPercent}%`,
        right: `${100 - maxPercent}%`,
      }}
    />
    <div
      className="absolute top-1/2 -translate-y-1/2 -translate-x-1/2"
      style={{ left: `${minPercent}%` }}
    >
      <div className="h-4 w-4 rounded-full bg-emerald-500 border border-white shadow" />
    </div>
    <div
      className="absolute top-1/2 -translate-y-1/2 -translate-x-1/2"
      style={{ left: `${maxPercent}%` }}
    >
      <div className="h-4 w-4 rounded-full bg-emerald-500 border border-white shadow" />
    </div>

    {/* UPDATED invisible range inputs */}
    <input
      type="range"
      min={min}
      max={max}
      value={minValue}
      onChange={handleMinChange}
      className="absolute top-0 bottom-0 left-0 w-1/2 opacity-0 cursor-pointer z-20"
    />
    <input
      type="range"
      min={min}
      max={max}
      value={maxValue}
      onChange={handleMaxChange}
      className="absolute top-0 bottom-0 right-0 w-1/2 opacity-0 cursor-pointer z-10"
    />
  </div>
</div>

  );
}
