"use client";
import Link from "next/link";
import type { ElementType } from "react";

type Props = {
  href?: string;
  label?: string;
  icon?: ElementType; // icon component, e.g. HiOutlineUser
  iconClassName?: string;
};

export default function BtnStyleTwo({
  href = "#",
  label = "Click Me",
  icon: Icon,
  iconClassName = "w-5 h-5",
}: Props) {
  return (
    <Link
      href={href}
      className="inline-flex items-center gap-2 bg-[#0B8260] hover:bg-[#0a6f51] text-white px-4 py-2 rounded-lg text-sm font-medium shadow-sm transition"
    >
      {Icon ? <Icon className={iconClassName} /> : null}
      <span>{label}</span>
    </Link>
  );
}
