"use client";
import Link from "next/link";

export default function BtnStyleOne({
  href = "#",
  label = "Click Me",
}: {
  href?: string;
  label?: string;
}) {
  return (
    <Link
      href={href}
      className="inline-flex items-center gap-2 bg-[#0B8260] hover:bg-[#0a6f51] text-white px-4 py-2 rounded-lg text-sm font-medium shadow-sm transition"
    >
      <span>{label}</span>
    </Link>
  );
}
